class DanesPumpkin extends UT_Invisibility config(DanesHalloween);

#exec mesh import mesh=Pumpkin anivfile=Models\Pumpkin_a.3d datafile=Models\Pumpkin_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=Pumpkin x=0 y=0 z=0
#exec mesh sequence mesh=Pumpkin seq=All startframe=0 numframes=1
#exec meshmap new meshmap=Pumpkin mesh=Pumpkin
#exec meshmap scale meshmap=Pumpkin x=0.14063 y=0.14063 z=0.28125

#exec TEXTURE IMPORT NAME=PumpKinTexture FILE=Textures\PumpKinTexture.bmp
#exec TEXTURE IMPORT NAME=PumpKinTexture2 FILE=Textures\PumpKinTexture2.bmp

//var() int HealingAmount;
//var() bool bSuperHeal;

var config int PickupHealth, HealthMax;

auto state Pickup
{	
	function Touch( actor Other )
	{
		local int HealMax;
		local Pawn P;
			
		if ( ValidTouch(Other) ) 
		{	
			P = Pawn(Other);	
			HealMax = HealthMax;
			//HealingAmount = PickupHealth;
			//if (bSuperHeal) HealMax = Min(199, HealMax * 2.0);
			if (P.Health < HealMax) 
			{
				if (Level.Game.LocalLog != None)
					Level.Game.LocalLog.LogPickup(Self, P);
				if (Level.Game.WorldLog != None)
					Level.Game.WorldLog.LogPickup(Self, P);
				P.Health += PickupHealth;
				if (P.Health > HealMax) P.Health = HealMax;
				//PlayPickupMessage(P);
				PlaySound (PickupSound,,2.5);
				Other.MakeNoise(0.2);		
				SetRespawn();
			}
		}
	}
}

state Activated
{
	function endstate()
	{
		bActive = false;			
	}

	function Activate()
	{
		bActive = true;	
	}

	
	function ChangedWeapon()
	{
		if ( !bActive )
			return;
		if( Inventory != None )
			Inventory.ChangedWeapon();
	}

	function Timer()
	{
		Charge -= 1;
		
		if (Charge<-0)
			UsedUp();
	}

	function BeginState()
		{
		bActive = true;
		}
}

state DeActivated
{
Begin:
}

defaultproperties
{
  DrawType=DT_Mesh
  Mesh=Mesh'Pumpkin'
  PickupViewMesh=Mesh'Pumpkin'
  bCollideWhenPlacing=True
  bCollideActors=True
  bCollideWorld=True
  bBlockActors=True
  bBlockPlayers=True
  CollisionRadius=41.60000
  CollisionHeight=36.00000
  MultiSkins(0)=Texture'DanesHalloween.PumpkinTexture'
  MultiSkins(1)=Texture'DanesHalloween.PumpkinTexture2'
  bRotatingPickup=True
  //RotationRate=(Roll=1500)
  //RotationRate=(Pitch=12250)
  //RotationRate=(Yaw=12000)
  PickupMessage="You found a pumpkin."
  ItemName="DanesPumpkin"
  PickupSound=Sound'UnrealShare.Pickups.Health2'
  ActivateSound=Sound'UnrealI.Pickups.Invisible'
  RespawnTime=20.000000
  ExpireMessage=" "
  bAutoActivate=True
  bActivatable=True
  bDisplayableInv=True
  Charge=100
}
